// AddrDlg.cpp : implementation file
//

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************

#include "stdafx.h"
#include "Addr.h"
#include "AddrDlg.h"
#include <atlbase.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CAddrApp theApp;
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddrDlg dialog

CAddrDlg::CAddrDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAddrDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddrDlg)
	m_City = _T("");
	m_Address = _T("");
	m_State = _T("");
	m_ZIP = _T("");
	m_Plus4 = _T("");
	m_Add_Err_Code = _T("");
	m_Company = _T("");
	m_Build_Number = _T("");
	m_Database_Date = _T("");
	m_Results = _T("");
	m_Init_Err_String = _T("");
	m_cAddress=_T("");
	m_Address2 = _T("");
	m_CAddress2 = _T("");
	m_CCity = _T("");
	m_CCompany = _T("");
	m_CPlus4 = _T("");
	m_CState = _T("");
	m_CZip = _T("");
	m_ExpDate = _T("");
	m_Suite = _T("");
	m_LastName = _T("");

	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	add = NULL;
	addCreated = false;

	//Initialize the COM library
	CoInitialize(0);
}

CAddrDlg::~CAddrDlg()
{
	//Release the Address Object

	if (add)
	{
		add->Release();
		add = NULL;
	}


	//Uninitializes the COM library
	CoUninitialize();
}

void CAddrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddrDlg)
	DDX_Control(pDX, IDC_OUTPUT, m_Output);
    DDX_Text(pDX, IDC_CITY, m_City);
	DDX_Text(pDX, IDC_ADDRESS, m_Address);
	DDX_Text(pDX, IDC_STATE, m_State);
	DDX_Text(pDX, IDC_ZIP, m_ZIP);
	DDX_Text(pDX, IDC_PLUS4, m_Plus4);
	DDX_Text(pDX, IDC_COMPANY, m_Company);
	DDX_Text(pDX, IDC_BUILD_NUMBER, m_Build_Number);
	DDX_Text(pDX, IDC_DB_DATE, m_Database_Date);
	DDX_Text(pDX, IDC_RESULTS, m_Results);
	DDX_Text(pDX, IDC_INIT_ERR, m_Init_Err_String);
	DDX_Text(pDX, IDC_CADDRESS, m_cAddress);
	DDX_Text(pDX, IDC_ADDRESS2, m_Address2);
	DDX_Text(pDX, IDC_CADDRESS2, m_CAddress2);
	DDX_Text(pDX, IDC_CCITY, m_CCity);
	DDX_Text(pDX, IDC_CCOMPANY, m_CCompany);
	DDX_Text(pDX, IDC_CPLUS4, m_CPlus4);
	DDX_Text(pDX, IDC_CSTATE, m_CState);
	DDX_Text(pDX, IDC_CZIP, m_CZip);
	DDX_Text(pDX, IDC_EXPDATE, m_ExpDate);
	DDX_Text(pDX, IDC_SUITE, m_Suite);
	DDX_Text(pDX, IDC_LASTNAME, m_LastName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAddrDlg, CDialog)
	//{{AFX_MSG_MAP(CAddrDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_VERIFY, OnVerify)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddrDlg message handlers

BOOL CAddrDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.


	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	// when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	try
	{
		// New COM - AddressCoder Object - AddressCheck interface
		add = new IAddressCheckPtr(__uuidof(AddressCheck));

		addCreated = true;
		//Created Address COM, so run initialization.
		
		initAddressCheck();
	}
	catch(const _com_error &e)
	{
		AfxMessageBox(e.ErrorMessage());
	}

	//Setting the default data in our dialogue
	UpdateData();
	m_Company="ABC Company";
	m_Address="201 10th. Street";
	m_City="Las Vegas";
	m_State="NV";
	m_ZIP="89101";
	UpdateData(false);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAddrDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAddrDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAddrDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAddrDlg::OnClear()
{
	//Clear data on click
	m_Address.Empty();
    m_Address2.Empty();
	m_City.Empty();
	m_State.Empty();
	m_ZIP.Empty();
	m_Cart.Empty();
	m_Add_Err_Code.Empty();
	m_Company.Empty();
	m_Results.Empty();
	m_Output.ResetContent();
	m_cAddress.Empty();
	m_LastName.Empty();

	m_cAddress.Empty();
	m_CAddress2.Empty();
	m_Suite.Empty();
	m_CCity.Empty();
	m_CCompany.Empty();
	m_CPlus4.Empty();
	m_CState.Empty();
	m_CZip.Empty();
    m_Plus4.Empty();
	
	UpdateData(FALSE);

}



void CAddrDlg::OnVerify()
{
	//Verify Data on Click
	//Needed to handle the BSTR's
	CComBSTR retStr;
	CString cBuf = "";
	long verified;

	//Let's clear our properties
	add->ClearProperties();

	UpdateData();

	//Needed to handle our input and insert into Address properties.
	_bstr_t szCompany((LPCTSTR)m_Company);
	add->Company = szCompany;

	_bstr_t szAddress((LPCTSTR)m_Address);
	add->Address = szAddress;

	_bstr_t szAddress2((LPCTSTR)m_Address2);
	add->Address2 = szAddress2;

	_bstr_t szCity((LPCTSTR)m_City);
	add->City = szCity;

	_bstr_t szState((LPCTSTR)m_State);
	add->State = szState;

	_bstr_t szZip((LPCTSTR)m_ZIP);
	add->Zip = szZip;

	_bstr_t szZip4((LPCTSTR)m_Plus4);
	add->Plus4 = szZip4;

	_bstr_t szLastName((LPCTSTR)m_LastName);
	add->LastName = szLastName;


	//Verify the Address 
	verified = add->VerifyAddress();
	
    m_Results = "";
	

	if ((strstr(add->Results,"AS01")!=0) || (strstr(add->Results,"AS02")!=0) || (strstr(add->Results,"AS03")!=0)) 
	{
		// address was fully coded OR coded but not to suite level
	    if (strstr(add->Results,"AS01")!=0)
	      	m_Results = "AS01: Full Address Matched to Postal Database\r\n";
        if (strstr(add->Results,"AS02")!=0)
            m_Results += "AS02: Address matched to USPS database but a suite was missing or invalid\r\n";
		if (strstr(add->Results,"AS03")!=0)
            m_Results += "AS03: Valid physical address, not serviced by the USPS\r\n";
	}  
	
	// display additional level of verification/comments
		
	if (strstr(add->Results,"AS09")!=0)
	   	m_Results += "AS09: Foreign Postal Code Detected \r\n";
    if (strstr(add->Results,"AS10")!=0)
        m_Results += "AS10: Address Matched to CMRA\r\n";
    if (strstr(add->Results,"AS13")!=0)
        m_Results += "AS13: Address has been Updated by LACSLink \r\n";
    if (strstr(add->Results,"AS14")!=0)
        m_Results += "AS14: Suite Appended by SuiteLink \r\n";
    if (strstr(add->Results,"AS15")!=0)
        m_Results += "AS15: Suite Appended by SuiteFinder \r\n";
    if (strstr(add->Results,"AS16")!=0)
        m_Results += "AS16: Address is vacant.\r\n";
    if (strstr(add->Results,"AS17")!=0)
        m_Results += "AS17: Alternate delivery.\r\n";
	if (strstr(add->Results,"AS18")!=0)
        m_Results += "AS18: Artificially created adress detected. DPV processing terminated at this point\r\n";
  	if (strstr(add->Results,"AS20")!=0)
	   	m_Results += "AS20: Address Deliverable by USPS only \r\n";
	if (strstr(add->Results,"AS21")!=0)
	   	m_Results += "AS21: Alternate Address Suggestion Found \r\n";
    if (strstr(add->Results,"AS22")!=0)
        m_Results += "AS22: No Alternate Address Suggestion Found\r\n";
    if (strstr(add->Results,"AS23")!=0)
        m_Results += "AS23: Extraneous information found \r\n";
     
	if (strstr(add->Results,"AE")!=0) 
	{
		// there was an error verifying the address
		if (strstr(add->Results,"AE01")!=0)
            m_Results += "AE01: Zip Code Error \r\n";
        if (strstr(add->Results,"AE02")!=0)
            m_Results += "AE02: Unknown Street Error \r\n";
        if (strstr(add->Results,"AE03")!=0)
            m_Results += "AE03: Component Mismatch Error \r\n";
        if (strstr(add->Results,"AE04")!=0)
            m_Results += "AE04: Non-Deliverable Address Error \r\n";
        if (strstr(add->Results,"AE05")!=0)
            m_Results += "AE05: Multiple Match Error \r\n";
        if (strstr(add->Results,"AE06")!=0)
            m_Results += "AE06: Early Warning System Error \r\n";
        if (strstr(add->Results,"AE07")!=0)
            m_Results += "AE07: Missing Minimum Address Input \r\n";
        if (strstr(add->Results,"AE08")!=0)
            m_Results += "AE08: Suite Range Invalid Error\r\n";
        if (strstr(add->Results,"AE09")!=0)
            m_Results += "AE09: Suite Range Missing Error \r\n";
        if (strstr(add->Results,"AE10")!=0)
            m_Results += "AE10: Primary Range Invalid Error \r\n";
        if (strstr(add->Results,"AE11")!=0)
            m_Results += "AE11: Primary Range Missing Error \r\n";
        if (strstr(add->Results,"AE12")!=0)
            m_Results += "AE12: PO, HC, or RR Box Number Invalid \r\n";
        if (strstr(add->Results,"AE13")!=0)
            m_Results += "AE13: PO, HC, or RR Box Number Missing \r\n";
        if (strstr(add->Results,"AE14")!=0)
            m_Results += "AE14: CMRA Secondary Missing Error\r\n";

		// program can not attempt address lookup
        if (strstr(add->Results,"AE15")!=0)
            m_Results += "AE15: Demo Mode limitation. Please contact your sales rep. \r\n";
        if (strstr(add->Results,"AE16")!=0)
            m_Results += "AE16: Expired Database, Please update.\r\n";

		if (strstr(add->Results,"AE17")!=0)
            m_Results += "AE17: Unnecessary Suite Error \r\n";
        if (strstr(add->Results,"AE19")!=0)
            m_Results += "AE19: Max time for FindSuggestion exceeded \r\n";
        if (strstr(add->Results,"AE20")!=0)
            m_Results += "AE20: FindSuggestion cannot be used\r\n";
	}

	if (strstr(add->Results,"AC01")!=0)
	   	m_Results += "AC01: ZIP Code Change \r\n";
    if (strstr(add->Results,"AC02")!=0)
        m_Results += "AC02: State Change\r\n";
    if (strstr(add->Results,"AC03")!=0)
        m_Results += "AC03: City Change \r\n";
    if (strstr(add->Results,"AC04")!=0)
        m_Results += "AC04: Base/Alternate Change \r\n";
    if (strstr(add->Results,"AC05")!=0)
        m_Results += "AC05: Alias Name Change \r\n";
    if (strstr(add->Results,"AC06")!=0)
        m_Results += "AC06: Address1/Address2 Swap\r\n";
    if (strstr(add->Results,"AC07")!=0)
        m_Results += "AC07: Address1/Company Swap\r\n";
	  if (strstr(add->Results,"AC08")!=0)
        m_Results += "AC08: Plus4 Change\r\n";
  	if (strstr(add->Results,"AC09")!=0)
	     	m_Results += "AC09: Urbanization Change \r\n";
	  if (strstr(add->Results,"AC10")!=0)
	    	m_Results += "AC10: Street Name Change \r\n";
    if (strstr(add->Results,"AC11")!=0)
        m_Results += "AC11: Street Suffix Change\r\n";
	  if (strstr(add->Results,"AC12")!=0)
	    	m_Results += "AC12: Street Directional Change \r\n";
    if (strstr(add->Results,"AC13")!=0)
        m_Results += "AC13: Suite Name Change\r\n";

        m_Output.ResetContent();
		//If you got here then the AddressCheck was successful and we can start
		//to gather our output
				
		//We call the GetAddress method to retrieve the Company
		retStr = (LPCOLESTR)add->GetCompany();
		//BSTR to CString
		m_CCompany = retStr.Detach();

		//We call the GetAddress method to retrieve the Address
		retStr = (LPCOLESTR)add->GetAddress();
		//BSTR to CString
		m_cAddress = retStr.Detach();

		//We call the GetSuite method to retrieve the Suite
		retStr = (LPCOLESTR)add->GetSuite();
		//BSTR to CString and append to the Address
		m_Suite = retStr.Detach();

		//We call the GetCity method to retrieve the City
		retStr = (LPCOLESTR)add->GetCity();
		//BSTR to CString
		m_CCity = retStr.Detach();

		//We call the GetState method to retrieve the State
		retStr = (LPCOLESTR)add->GetState();
		//BSTR to CString
		m_CState = retStr.Detach();

		//We call the GetZip method to retrieve the ZIP Code
		retStr = (LPCOLESTR)add->GetZip();
		//BSTR to CString
		m_CZip = retStr.Detach();

		//We call the GetPlus4 method to retrieve the Plus4
		retStr = (LPCOLESTR)add->GetPlus4();
		//BSTR to CString
		m_CPlus4 = retStr.Detach();

		

		//Update the buffer for the rest of the address properties.
	    retStr = (LPCOLESTR) add->CarrierRoute;
		cBuf = retStr.Detach();
		m_Output.AddString("CarrierRoute: "+ cBuf);	
		retStr = (LPCOLESTR) add->DeliveryPointCode;
		cBuf = retStr.Detach();
		m_Output.AddString("DeliveryPointCode: "+ cBuf);
        retStr = (LPCOLESTR) add->DeliveryPointCheckDigit;
		cBuf = retStr.Detach();
		m_Output.AddString("DeliveryPointCheckDigit: "+ cBuf);
        retStr = (LPCOLESTR) add->DPVFootnotes;
		cBuf = retStr.Detach();
		m_Output.AddString("DPVFootnotes: "+ cBuf);
		m_Output.AddString("");
		retStr = (LPCOLESTR) add->AddressTypeCode;
		cBuf = retStr.Detach();
		m_Output.AddString("AddressTypeCode: "+ cBuf);
        retStr = (LPCOLESTR) add->AddressTypeString;
		cBuf = retStr.Detach();
		m_Output.AddString("AddressTypeString: "+ cBuf);
        retStr = (LPCOLESTR) add->CityAbbreviation;
		cBuf = retStr.Detach();
		m_Output.AddString("CityAbbreviation: "+ cBuf);
        retStr = (LPCOLESTR) add->CountyName;
		cBuf = retStr.Detach();
		m_Output.AddString("CountyName: "+ cBuf);
	    retStr = (LPCOLESTR) add->CountyFips;
		cBuf = retStr.Detach();
		m_Output.AddString("CountyFips: "+ cBuf);
        retStr = (LPCOLESTR) add->CountryCode;
		cBuf = retStr.Detach();
		m_Output.AddString("CountryCode: "+ cBuf);
		retStr = (LPCOLESTR) add->CongressionalDistrict;
		cBuf = retStr.Detach();
		m_Output.AddString("CongressionalDistrict: "+ cBuf);
		retStr = (LPCOLESTR) add->TimeZone;
		cBuf = retStr.Detach();
		m_Output.AddString("TimeZone: "+ cBuf);
		retStr = (LPCOLESTR) add->TimeZoneCode;
		cBuf = retStr.Detach();
		m_Output.AddString("TimeZoneCode: "+ cBuf);
		retStr = (LPCOLESTR) add->Urbanization;
		cBuf = retStr.Detach();
		m_Output.AddString("Urbanization: "+ cBuf);
		retStr = (LPCOLESTR) add->ZipType;
		cBuf = retStr.Detach();
		m_Output.AddString("ZipType: "+ cBuf);
        m_Output.AddString("");
		retStr = (LPCOLESTR) add->ParsedAddressRange;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedAddressRange: "+ cBuf);
        retStr = (LPCOLESTR) add->ParsedPreDirection;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedPreDirection: "+ cBuf);
        retStr = (LPCOLESTR) add->ParsedStreetName;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedStreetName: "+ cBuf);
		retStr = (LPCOLESTR) add->ParsedSuffix;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedSuffix: "+ cBuf);
        retStr = (LPCOLESTR) add->ParsedPostDirection;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedPostDirection: "+ cBuf);
        retStr = (LPCOLESTR) add->ParsedSuiteName;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedSuiteName: "+ cBuf);
        retStr = (LPCOLESTR) add->ParsedSuiteRange;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedSuiteRange: "+ cBuf);
	    retStr = (LPCOLESTR) add->ParsedPrivateMailboxName;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedPrivateMailboxName: "+ cBuf);
        retStr = (LPCOLESTR) add->ParsedPrivateMailboxNumber;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedPrivateMailboxNumber: "+ cBuf);
        retStr = (LPCOLESTR) add->ParsedGarbage;
		cBuf = retStr.Detach();
		m_Output.AddString("ParsedGarbage: "+ cBuf);
        m_Output.AddString("");
        retStr = (LPCOLESTR) add->Msa;
		cBuf = retStr.Detach();
		m_Output.AddString("Msa: "+ cBuf);
        retStr = (LPCOLESTR) add->Pmsa;
		cBuf = retStr.Detach();
		m_Output.AddString("Pmsa: "+ cBuf);
		retStr = (LPCOLESTR) add->CMRA;
		cBuf = retStr.Detach();
		m_Output.AddString("CMRA: "+ cBuf);
		retStr = (LPCOLESTR) add->PrivateMailbox;
		cBuf = retStr.Detach();
		m_Output.AddString("PrivateMailbox: "+ cBuf);
        m_Output.AddString("");
		retStr = (LPCOLESTR) add->ELotOrder;
		cBuf = retStr.Detach();
		m_Output.AddString("ELotOrder: "+ cBuf);
		retStr = (LPCOLESTR) add->ELotNumber;
		cBuf = retStr.Detach();
		m_Output.AddString("ELotNumber: "+ cBuf);
		retStr = (LPCOLESTR) add->Lacs;
		cBuf = retStr.Detach();
		m_Output.AddString("Lacs: "+ cBuf);
		retStr = (LPCOLESTR) add->LACSLinkIndicator;
		cBuf = retStr.Detach();
		m_Output.AddString("LACSLinkIndicator: "+ cBuf);
		retStr = (LPCOLESTR) add->LACSLinkReturnCode;
		cBuf = retStr.Detach();
		m_Output.AddString("LACSLinkReturnCode: "+ cBuf);
        retStr = (LPCOLESTR) add->SuiteLinkReturnCode;
		cBuf = retStr.Detach();
		m_Output.AddString("SuiteLinkReturnCode: "+ cBuf);
        retStr = (LPCOLESTR) add->EWSFlag;
		cBuf = retStr.Detach();
		m_Output.AddString("EWSFlag: "+ cBuf);
        retStr = (LPCOLESTR) add->RBDI;
		cBuf = retStr.Detach();
		m_Output.AddString("RBDI: "+ cBuf);
		

		//Let's clear our properties
		add->ClearProperties();

	UpdateData(FALSE);

}

void CAddrDlg::OnCancel()
{
	// TODO: Add extra cleanup here

	CDialog::OnCancel();
}

bool CAddrDlg::initAddressCheck()
{
	COleDateTime date;
	CComBSTR ccbString;

	//Check if not created
	if ( addCreated == false )
		return false;

	UpdateData();

	//Setting License String here.  License must be set before initialization.
	add->SetLicenseString(_bstr_t(dLICENSE));

	//Here is where we call the Initialize method

	//First we must set the path to the U.S. data files
	add->PathToUSFiles = _bstr_t(dFILELOC);

	//CASS required add-ons for highest level of validation. Should be used by non-demo users.
	add->PathToDPVDataFiles = _bstr_t(dFILELOC);
    add->PathToLACSLinkDataFiles = _bstr_t(dFILELOC);
    add->PathToSuiteLinkDataFiles = _bstr_t(dFILELOC);

    //add->PathToCanadaFiles = _bstr_t(dFILELOC);           //Canadian Address Validation Add-on
	//add->PathToRBDIFiles = _bstr_t(dFILELOC);             //Delivery Indicator Add-on (Residence or Business)
    //add->PathToSuiteFinderDataFiles = _bstr_t(dFILELOC);  //AddressPlus Add-on (appends residential suites)

	//Here is where we call the Initialize method
	if (add->InitializeDataFiles() != 0)
	{
		// Error -- so let's find out what went wrong with a simple call to the
		// GetInitializeErrorString method
		ccbString = (LPCOLESTR)add->GetInitializeErrorString();

		//Pass the Error string back from a BSTR to a CString
		m_Init_Err_String = ccbString.Detach();
        UpdateData(FALSE);
		return false;
	}

	//the initialization was successful.

	// A call to the GetDatabaseDate method
	date = add->GetUSDatabaseDate();

	//Just a little Date manipulation so we can view the Date
	m_Database_Date.Format("%d/%d/%d", date.GetMonth(), date.GetDay(), date.GetYear());

	// A simple call to the GetBuildNumber method
	ccbString = (LPCOLESTR)add->GetBuildNumber();

	//Get Expiration Date
	date = add->GetUSExpirationDate();

	//Just a little Date manipulation so we can view the Date
	m_ExpDate.Format("%d/%d/%d", date.GetMonth(), date.GetDay(), date.GetYear());

	//BSTR to CString
	m_Build_Number = ccbString.Detach();

	//Just to show you the Error string returned from a successful Initialization
	ccbString = (LPCOLESTR)add->GetInitializeErrorString();

	//BSTR to CString
	m_Init_Err_String = ccbString.Detach();

	UpdateData(FALSE);

	return true;
}


